/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.NBTTags;
import noppes.npcs.Server;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.constants.RoleType;
import noppes.npcs.api.entity.data.INPCAdvanced;
import noppes.npcs.api.handler.data.IFaction;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.FactionOptions;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.Lines;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataScenes;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.roles.RoleTrader;
import noppes.npcs.util.ValueUtil;

public class DataAdvanced
implements INPCAdvanced {
    public boolean attackOtherFactions = false;
    public boolean defendFaction = false;
    public boolean disablePitch = false;
    public boolean orderedLines = false;
    public boolean throughWalls = true;
    public JobInterface jobInterface;
    public RoleInterface roleInterface;
    private String angrySound = "";
    private String deathSound = "minecraft:entity.player.hurt";
    private String hurtSound = "minecraft:entity.player.hurt";
    private String idleSound = "";
    private String stepSound = "";
    private final EntityNPCInterface npc;
    public Lines interactLines = new Lines();
    public Lines npcInteractLines = new Lines();
    public Lines worldLines = new Lines();
    public Lines attackLines = new Lines();
    public Lines killedLines = new Lines();
    public Lines killLines = new Lines();
    public FactionOptions factions = new FactionOptions();
    public EntityNPCInterface spawner;
    public DataScenes scenes;
    public HashSet<Integer> attackFactions = new HashSet();
    public HashSet<Integer> friendFactions = new HashSet();

    public DataAdvanced(EntityNPCInterface npcIn) {
        this.npc = npcIn;
        this.jobInterface = new JobInterface(this.npc);
        this.roleInterface = new RoleInterface(this.npc);
        this.scenes = new DataScenes(this.npc);
    }

    public Line getAttackLine() {
        return this.attackLines.getLine(!this.orderedLines);
    }

    public Line getInteractLine() {
        return this.interactLines.getLine(!this.orderedLines);
    }

    public Line getKilledLine() {
        return this.killedLines.getLine(!this.orderedLines);
    }

    public Line getKillLine() {
        return this.killLines.getLine(!this.orderedLines);
    }

    @Override
    public String getLine(int type, int slot) {
        Lines lines = this.getLines(type);
        if (lines == null) {
            return null;
        }
        Line line = lines.lines.get(slot);
        if (line == null) {
            return null;
        }
        return line.getText();
    }

    @Override
    public int getLineCount(int type) {
        Lines lines = this.getLines(type);
        return lines == null ? 0 : lines.lines.size();
    }

    private Lines getLines(int type) {
        switch (type) {
            case 0: {
                return this.interactLines;
            }
            case 1: {
                return this.attackLines;
            }
            case 2: {
                return this.worldLines;
            }
            case 3: {
                return this.killedLines;
            }
            case 4: {
                return this.killLines;
            }
            case 5: {
                return this.npcInteractLines;
            }
        }
        return null;
    }

    public Line getNPCInteractLine() {
        return this.npcInteractLines.getLine(!this.orderedLines);
    }

    @Override
    public String getSound(int type) {
        String sound = null;
        switch (type) {
            case 0: {
                sound = this.idleSound;
                break;
            }
            case 1: {
                sound = this.angrySound;
                break;
            }
            case 2: {
                sound = this.hurtSound;
                break;
            }
            case 3: {
                sound = this.deathSound;
                break;
            }
            case 4: {
                sound = this.stepSound;
                break;
            }
        }
        if (sound != null && sound.isEmpty()) {
            sound = null;
        }
        return sound;
    }

    public Line getWorldLine() {
        return this.worldLines.getLine(!this.orderedLines);
    }

    public boolean hasWorldLines() {
        return !this.worldLines.isEmpty();
    }

    private boolean isAggressive(PlayerFactionData data, EntityPlayer player, Faction faction) {
        return data.getFactionPoints(player, faction.id) < faction.neutralPoints;
    }

    public boolean isAggressiveToNpc(EntityNPCInterface entity) {
        return this.attackOtherFactions && (this.npc.faction.isAggressiveToNpc(entity) || this.attackFactions.contains(entity.faction.id));
    }

    public boolean isAggressiveToPlayer(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        PlayerFactionData data = PlayerData.get((EntityPlayer)player).factionData;
        if (this.isAggressive(data, player, this.npc.faction)) {
            return true;
        }
        FactionController fData = FactionController.instance;
        for (int id : this.attackFactions) {
            IFaction faction = fData.get(id);
            if (faction == null || !this.isAggressive(data, player, (Faction)faction)) continue;
            return true;
        }
        return false;
    }

    public void playSound(int type, float volume, float pitch) {
        String sound = this.getSound(type);
        if (sound == null) {
            return;
        }
        BlockPos pos = this.npc.func_180425_c();
        Server.sendRangedData((Entity)this.npc, 16, EnumPacketClient.PLAY_SOUND, sound, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Float.valueOf(volume), Float.valueOf(pitch));
    }

    public void load(NBTTagCompound compound) {
        if (!compound.func_74764_b("Role")) {
            return;
        }
        this.worldLines.readNBT(compound.func_74775_l("NpcLines"));
        this.attackLines.readNBT(compound.func_74775_l("NpcAttackLines"));
        this.interactLines.readNBT(compound.func_74775_l("NpcInteractLines"));
        this.killedLines.readNBT(compound.func_74775_l("NpcKilledLines"));
        this.killLines.readNBT(compound.func_74775_l("NpcKillLines"));
        this.npcInteractLines.readNBT(compound.func_74775_l("NpcInteractNPCLines"));
        this.orderedLines = compound.func_74767_n("OrderedLines");
        this.idleSound = compound.func_74779_i("NpcIdleSound");
        this.angrySound = compound.func_74779_i("NpcAngrySound");
        this.hurtSound = compound.func_74779_i("NpcHurtSound");
        this.deathSound = compound.func_74779_i("NpcDeathSound");
        this.stepSound = compound.func_74779_i("NpcStepSound");
        this.npc.setFaction(compound.func_74762_e("FactionID"));
        this.npc.faction = this.npc.getFaction();
        this.attackOtherFactions = compound.func_74767_n("AttackOtherFactions");
        this.defendFaction = compound.func_74767_n("DefendFaction");
        this.disablePitch = compound.func_74767_n("DisablePitch");
        this.factions.load(compound.func_74775_l("FactionPoints"));
        this.scenes.readFromNBT(compound.func_74775_l("NpcScenes"));
        this.throughWalls = !compound.func_150297_b("ThroughWalls", 1) ? true : compound.func_74767_n("ThroughWalls");
        if (compound.func_150297_b("Role", 3) && compound.func_150297_b("NpcJob", 3)) {
            this.setRole(compound.func_74762_e("Role"));
            this.setJob(compound.func_74762_e("NpcJob"));
            this.roleInterface.load(compound);
            this.jobInterface.load(compound);
        }
        if (compound.func_150297_b("Role", 10) && compound.func_150297_b("Job", 10)) {
            this.setRole(compound.func_74775_l("Role").func_74762_e("Type"));
            this.setJob(compound.func_74775_l("Job").func_74762_e("Type"));
            this.roleInterface.load(compound.func_74775_l("Role"));
            this.jobInterface.load(compound.func_74775_l("Job"));
        }
        if (this.roleInterface instanceof RoleTrader && compound.func_150297_b("MarketID", 3)) {
            this.roleInterface.load(compound);
        }
        if (compound.func_150297_b("NPCDialogOptions", 11)) {
            this.npc.dialogs = compound.func_74759_k("NPCDialogOptions");
        } else if (compound.func_150297_b("NPCDialogOptions", 9)) {
            NBTTagList list = compound.func_150295_c("NPCDialogOptions", 10);
            this.npc.dialogs = new int[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.npc.dialogs[i] = list.func_150305_b(i).func_74775_l("NPCDialog").func_74762_e("Dialog");
            }
        }
        this.attackFactions = NBTTags.getIntegerSet(compound.func_150295_c("AttackFactions", 10));
        this.friendFactions = NBTTags.getIntegerSet(compound.func_150295_c("FrendFactions", 10));
    }

    public void setJob(int i) {
        JobType.get(i).setToNpc(this.npc);
        if (!this.npc.field_70170_p.field_72995_K) {
            this.jobInterface.reset();
        }
    }

    @Override
    public void setLine(int type, int slot, String text, String sound) {
        slot = ValueUtil.correctInt(slot, 0, 7);
        Lines lines = this.getLines(type);
        if (lines == null) {
            return;
        }
        if (text == null || text.isEmpty()) {
            lines.lines.remove(slot);
        } else {
            Line line = lines.lines.computeIfAbsent(slot, k -> new Line());
            line.setText(text);
            line.setSound(sound);
        }
    }

    public void setRole(int i) {
        RoleType.get(i).setToNpc(this.npc);
    }

    @Override
    public void setSound(int type, String sound) {
        if (sound == null) {
            sound = "";
        }
        switch (type) {
            case 0: {
                this.idleSound = sound;
                break;
            }
            case 1: {
                this.angrySound = sound;
                break;
            }
            case 2: {
                this.hurtSound = sound;
                break;
            }
            case 3: {
                this.deathSound = sound;
                break;
            }
            case 4: {
                this.stepSound = sound;
            }
        }
    }

    public void tryDefendFaction(int id, EntityLivingBase possibleFriend, EntityLivingBase attacked) {
        if (this.npc.isKilled() || !this.defendFaction || possibleFriend.equals((Object)attacked)) {
            return;
        }
        boolean canSee = this.npc.canSee((Entity)possibleFriend);
        if (!canSee && this.throughWalls) {
            float dist = this.npc.func_70032_d((Entity)possibleFriend);
            boolean bl = canSee = dist <= (float)this.npc.stats.aggroRange;
        }
        if (this.npc.faction.id != id && !this.npc.faction.frendFactions.contains(id) && !this.friendFactions.contains(id) || !canSee) {
            return;
        }
        this.npc.onAttack(attacked);
    }

    public NBTTagCompound save(NBTTagCompound compound) {
        compound.func_74782_a("NpcLines", (NBTBase)this.worldLines.writeToNBT());
        compound.func_74782_a("NpcAttackLines", (NBTBase)this.attackLines.writeToNBT());
        compound.func_74782_a("NpcInteractLines", (NBTBase)this.interactLines.writeToNBT());
        compound.func_74782_a("NpcKilledLines", (NBTBase)this.killedLines.writeToNBT());
        compound.func_74782_a("NpcKillLines", (NBTBase)this.killLines.writeToNBT());
        compound.func_74782_a("NpcInteractNPCLines", (NBTBase)this.npcInteractLines.writeToNBT());
        compound.func_74757_a("OrderedLines", this.orderedLines);
        compound.func_74778_a("NpcIdleSound", this.idleSound);
        compound.func_74778_a("NpcAngrySound", this.angrySound);
        compound.func_74778_a("NpcHurtSound", this.hurtSound);
        compound.func_74778_a("NpcDeathSound", this.deathSound);
        compound.func_74778_a("NpcStepSound", this.stepSound);
        compound.func_74768_a("FactionID", this.npc.getFaction().id);
        compound.func_74757_a("AttackOtherFactions", this.attackOtherFactions);
        compound.func_74757_a("DefendFaction", this.defendFaction);
        compound.func_74757_a("ThroughWalls", this.throughWalls);
        compound.func_74757_a("DisablePitch", this.disablePitch);
        compound.func_74782_a("FactionPoints", (NBTBase)this.factions.save(new NBTTagCompound()));
        compound.func_74783_a("NPCDialogOptions", this.npc.dialogs);
        compound.func_74782_a("NpcScenes", (NBTBase)this.scenes.writeToNBT(new NBTTagCompound()));
        NBTTagCompound roleNbt = new NBTTagCompound();
        NBTTagCompound jobNbt = new NBTTagCompound();
        this.roleInterface.save(roleNbt);
        this.jobInterface.save(jobNbt);
        compound.func_74782_a("Role", (NBTBase)roleNbt);
        compound.func_74782_a("Job", (NBTBase)jobNbt);
        compound.func_74782_a("AttackFactions", (NBTBase)NBTTags.nbtIntegerCollection(this.attackFactions));
        compound.func_74782_a("FrendFactions", (NBTBase)NBTTags.nbtIntegerCollection(this.friendFactions));
        return compound;
    }
}

